/*
USE [master]
GO
DROP PROCEDURE [dbo].[WriteResultsToCsvFile]
DROP PROCEDURE [dbo].[WriteResultsToTabFile]
DROP ASSEMBLY [SQLCLRNet_BCPReplacement]
DROP USER SQLCLRNet_ExampleLogin
DROP LOGIN SQLCLRNet_ExampleLogin 
DROP ASYMMETRIC KEY SQLCLRNet_ExampleKey
GO
*/

USE [master]
GO
IF OBJECT_ID('[dbo].[WriteResultsToCsvFile]') IS NOT NULL
BEGIN
	DROP PROCEDURE [dbo].[WriteResultsToCsvFile]
END
GO

IF OBJECT_ID('[dbo].[WriteResultsToTabFile]') IS NOT NULL
BEGIN
	DROP PROCEDURE [dbo].[WriteResultsToTabFile]
END
GO

IF  EXISTS (SELECT * FROM sys.assemblies asms WHERE asms.name = N'SQLCLRNet_BCPReplacement')
DROP ASSEMBLY [SQLCLRNet_BCPReplacement]

GO

CREATE ASSEMBLY [SQLCLRNet_BCPReplacement]
AUTHORIZATION [dbo]
FROM 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
WITH PERMISSION_SET = SAFE

GO

ALTER ASSEMBLY [SQLCLRNet_BCPReplacement]
ADD FILE FROM 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
AS N'DelimitedFileWriter.cs'

GO

ALTER ASSEMBLY [SQLCLRNet_BCPReplacement]
ADD FILE FROM 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
AS N'Properties\AssemblyInfo.cs'

GO

ALTER ASSEMBLY [SQLCLRNet_BCPReplacement]
ADD FILE FROM 0x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
AS N'SQLCLRNet_BCPReplacement.pdb'

GO

ALTER ASSEMBLY [SQLCLRNet_BCPReplacement]
ADD FILE FROM 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
AS N'WriteResultsToCsvFile.cs'

GO

ALTER ASSEMBLY [SQLCLRNet_BCPReplacement]
ADD FILE FROM 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
AS N'WriteResultsToTabFile.cs'

GO

EXEC sys.sp_addextendedproperty @name=N'SqlAssemblyProjectRoot', @value=N'C:\Documents and Settings\jkehayias\Desktop\SQLCLRBulkCopy\SQLCLRNet_BCPReplacement\SQLCLRNet_BCPReplacement' , @level0type=N'ASSEMBLY',@level0name=N'SQLCLRNet_BCPReplacement'
GO


-- Create the Asymmetric Key from the Assembly
IF NOT EXISTS (SELECT 1 FROM sys.asymmetric_keys WHERE name = 'SQLCLRNet_ExampleKey')
BEGIN
	CREATE ASYMMETRIC KEY SQLCLRNet_ExampleKey 
	FROM ASSEMBLY [SQLCLRNet_BCPReplacement]
END
GO

-- Create the Login from the Asymmetric Key
IF NOT EXISTS (SELECT 1 FROM sys.server_principals WHERE name = 'SQLCLRNet_ExampleLogin')
BEGIN
	CREATE LOGIN SQLCLRNet_ExampleLogin 
	FROM ASYMMETRIC KEY SQLCLRNet_ExampleKey

	-- Grant the External Access Priviledge to the Login
	GRANT EXTERNAL ACCESS ASSEMBLY TO SQLCLRNet_ExampleLogin 
END
GO

-- Create the database user for Authorization on the Assembly if it doesn't exist already
IF NOT EXISTS (SELECT * FROM sys.database_principals WHERE name = 'SQLCLRNet_ExampleLogin')
BEGIN
	CREATE USER SQLCLRNet_ExampleLogin FOR LOGIN SQLCLRNet_ExampleLogin
END
GO

-- Set Authorization to the Database User
ALTER AUTHORIZATION ON ASSEMBLY::[SQLCLRNet_BCPReplacement] TO SQLCLRNet_ExampleLogin
GO

-- Set the Assembly for External Access
ALTER ASSEMBLY [SQLCLRNet_BCPReplacement] WITH PERMISSION_SET = EXTERNAL_ACCESS
GO

-- Create the TSQL Procedure that maps to the Assembly
CREATE PROCEDURE [dbo].[WriteResultsToCsvFile]
	@sqlcmd [nvarchar](4000),
	@filename [nvarchar](4000),
	@includeheaders [bit] = 1,
	@quoteall [bit] = 1,
	@provideoutput [bit] = 0
WITH EXECUTE AS CALLER
AS
EXTERNAL NAME [SQLCLRNet_BCPReplacement].[StoredProcedures].[WriteResultsToCsvFile]
GO

EXEC sys.sp_addextendedproperty @name=N'SqlAssemblyFile', @value=N'WriteResultsToCsvFile.cs' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'PROCEDURE',@level1name=N'WriteResultsToCsvFile'
GO

EXEC sys.sp_addextendedproperty @name=N'SqlAssemblyFileLine', @value=12 , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'PROCEDURE',@level1name=N'WriteResultsToCsvFile'
GO

-- Create the TSQL Procedure that maps to the Assembly
CREATE PROCEDURE [dbo].[WriteResultsToTabFile]
	@sqlcmd [nvarchar](4000),
	@filename [nvarchar](4000),
	@includeheaders [bit] = 1,
	@quoteall [bit] = 1,
	@provideoutput [bit] = 0
WITH EXECUTE AS CALLER
AS
EXTERNAL NAME [SQLCLRNet_BCPReplacement].[StoredProcedures].[WriteResultsToTabFile]
GO

EXEC sys.sp_addextendedproperty @name=N'SqlAssemblyFile', @value=N'WriteResultsToTabFile.cs' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'PROCEDURE',@level1name=N'WriteResultsToTabFile'
GO

EXEC sys.sp_addextendedproperty @name=N'SqlAssemblyFileLine', @value=12 , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'PROCEDURE',@level1name=N'WriteResultsToTabFile'
GO
